#declare GlassTexture =
	texture {
		pigment{ srgb < 0, 0, 0.4 > }
		finish {
			diffuse 0.4
			reflection 0.25
			specular 0.5
		}
	}

#declare SnowShelterTexture =
texture{ pigment{ wrinkles color_map{
									[0.0 Clear]
									[0.2 White ]
									[0.4 White]
									[0.6 White]
									[0.8 Clear ]
									[1.0 Clear]
							}
			}
			normal{ bumps 0.35 }
}


#declare TilesTexture = 
texture{
	pigment {wrinkles color_map { [0.0 Orange][0.2 White ][0.4 White][0.6 White][0.8 Orange ][1.0 Orange] } }
	normal{ bumps 0.35 }
}

#declare WindowFrameWidth1 = 0.5;
#declare WindowFrameWidth2 = 0.5;
#declare WindowFrameWidth3 = 0.5;

//Left side Window
#declare LeftWindow=
union {
	difference {//Window frame
		box{ <1,4,-32> <-1,14,-24>}
		box{ <2,4 + WindowFrameWidth1, -32 + WindowFrameWidth1 > < -3,14 - WindowFrameWidth1,-24 - WindowFrameWidth1 >}
			texture { T_Wood30}
	}
	difference {//Glass frames 
		box{ 	<-1.5, 4 + WindowFrameWidth1, -32> <-1, 14 - WindowFrameWidth1, -24 - WindowFrameWidth1 > }
		box{	<-3, 4 + WindowFrameWidth1 + WindowFrameWidth2,-32 + WindowFrameWidth1 + WindowFrameWidth2 > 
				<2, 14 - WindowFrameWidth1 - WindowFrameWidth2, -28 - WindowFrameWidth2 > }
		box{	<-3, 4 + WindowFrameWidth1 + WindowFrameWidth2, -28 + WindowFrameWidth2 > 
				<2, 14 - WindowFrameWidth1 - WindowFrameWidth2, -24 - WindowFrameWidth1 - WindowFrameWidth2 >}
		texture{ T_Wood11 }
	}
	box{	< -1.5, 4 + WindowFrameWidth1 + WindowFrameWidth2,-32 + WindowFrameWidth1 + WindowFrameWidth2> 
			< -1.5, 14 - WindowFrameWidth1 - WindowFrameWidth2,-28 - WindowFrameWidth2> texture {GlassTexture} }
	box{	< -1.5, 4 + WindowFrameWidth1 + WindowFrameWidth2, -28 + WindowFrameWidth2> 
			< -1.5, 14 - WindowFrameWidth1 - WindowFrameWidth2, -24 - WindowFrameWidth1 - WindowFrameWidth2 > texture {GlassTexture} }
}                                                                           

//Right side window
#declare SmallWindowFrame =
union{
	difference {
		box{<0,-1,-1> <-5,6,1>}   
		box{<-0.5,0,-1.1> <-4.5,5,1.1> } texture { T_Wood30}
	}
	box {<-0.5,0,-0.1><-4.5,5,0.1> texture {GlassTexture} }
}

#declare LeftDoorLatte =
prism{ linear_sweep linear_spline 0, 11, 5,    
	< 0, 0>, < 0, -1>, <0.1,-0.95>, <0.1,-0.15>, <0, 0>
}
  
#macro LeftDoorLattesMacro( )
	#for( It, 0, 5 )
		object{ LeftDoorLatte translate It * z }
	#end
#end       
     
#declare LeftDoorObj =
union {
	merge{ //Left side door frame
		box{<1,0,-12> <-1,12,-11.5>}
		box{<1,11,-12> <-1,12,-5>}
		box{<1,0,-5.5> <-1,12,-5>}
		translate 10*z
	}
	union{ LeftDoorLattesMacro( ) }
	box {<0,3,4.5><0.4,4,0>}
	texture {T_Wood11}
}
 
#declare GarretLatte = 
prism{ linear_sweep linear_spline 0, 8, 5,    
	< 0, 0>, < 0, 1>, <0.1,0.9>, <0.1,0.1>, <0, 0>
}

#declare Sphere3 =
sphere {<0,0,0>,0.2 pigment {Gray}}

#macro ShutterMacro( )
	#local Z3=0.5;
	#local Y3=1.5;
	#for( ItN3, 1, 10 )
		object{ Sphere3 translate < 0.3, Y3, Z3 > }
		#local Z3 = Z3 + 1;
		#if( ItN3 = 5 
		)
			#local Y3 = 6.5;
			#local Z3 = 0.5;
		#end
	#end
#end


#declare CompleteShutter=   
union {
       object{ GarretLatte }   
       object{ GarretLatte translate 1 * z }  
       object{ GarretLatte translate 2 * z }
       object{ GarretLatte translate 3 * z }
       object{ GarretLatte translate 4 * z }
       box{ < 0.1 ,1 , 0.2 > < 0.3, 2, 4.8 > }
       box{ < 0.1 ,6, 0.2 > < 0.3, 7, 4.8 > }  
       object{ union{ ShutterMacro() } }
       texture {T_Wood11}
       }                                     
       
#declare UpstairWindow =
union {
	difference{
		box{<0,0,0> <0.1,8,10>}
		box{<-1,0.5,0.5> <1,7.5,4.5>}
		box{<-1,0.5,5.5> <1,7.5,9.5>}
			texture {T_Wood11} 
	}
	box {<0,0.5,0.5><-0.01,7.5,4.5> texture {GlassTexture} }
	box {<0,0.5,5.5><-0.01,7.5,9.5> texture {GlassTexture} }
	object {CompleteShutter translate -5*z}
	object {CompleteShutter translate 10*z}
	box {<0,-1,-1> <1.5,0,11> texture { T_Wood7}}
}

#declare BalconyGround = box{ < 0, 0, 0 > < 40, 1, 6 > texture{ T_Wood30 } }
        
#declare AboveCrossBar =
union{
	box{<0,7,0> <1,7.5,6>}
	box{<0 ,7,5 > <40 ,7.5,6 >}
	box{<39 ,7,0 > <40 ,7.5,6 >}
	texture {T_Wood30}
}

#declare BelowCrossBar =
prism{ linear_sweep linear_spline 0.5 ,0 ,6
        <0,0> <0,6> <0.5,6> <1, 5.5> <1,0> <0, 0> rotate -90*z 
}

#declare CrossBarsGroup = union{
	#for( B1, 0, 37.5, 2.5 )
		object {BelowCrossBar translate < B1, 0, 0 >}  
	#end
	texture{ T_Wood30 }
}        

#declare BalconyBar = cylinder {< 0, 0, 0 > < 0, 6, 0 > 0.2 }

#declare BalconyFrontBarsGroup =
union{
	#for( It, 0, 39, 2.5 )
		object{ BalconyBar translate < It + 1, 1, 5.5 > }
	#end
	texture{ T_Wood30 }
}         

#declare LargeCornerBar = box{ < 0, 0, 0 > < 1, 6, 1 > texture { T_Wood30} }

#declare LeftBarsGroup =
union{
	#for( It, 0.5, 5, 2.5 )
		object{ BalconyBar translate < 0.5, 1, It > }
	#end
	texture { T_Wood30}
}

#declare RightBarsGroup =
union{
	#for( It, 0.5, 5, 2.5 )
		object{ BalconyBar translate < 39.5, 1, It > }
	#end
	texture { T_Wood30}
}

#declare CompleteBalcony =
union {
	object{ BalconyGround }
	object{ CrossBarsGroup }
	object{ BalconyFrontBarsGroup }
	object{ LeftBarsGroup }
	object{ RightBarsGroup }
	object{ AboveCrossBar }
	object{ LargeCornerBar translate < 0, 1, 5 > }
	object{ LargeCornerBar translate < 39, 1, 5 > }
}

#declare Latte1 = prism{ linear_sweep linear_spline -60, 0, 5, < 0,  0>, < -0.1, 0.1>, < -0.9,  0.1>, <-1, 0> <0, 0> rotate -90*z }
          

#declare Latte2 = prism{ linear_sweep linear_spline 40, 0, 5, < 0,  0>, < 0, 1>, <0.1,  0.9>, <0.1, 0.1>, <0, 0> rotate -90*x }

#declare GarretLatte = prism { linear_sweep linear_spline 20, 0, 5, < 0,  0>, < -0.1, 0.1>, < -0.9,  0.1>, <-1, 0>, <0,0> translate < 0, 30, 0 > }

#declare IntersectionFrontPrism = prism { linear_sweep linear_spline 50, -10, 6 <2,-40>  <2,0> <-30,15><-62,0> <-62,-40>, <2, -40> 
											rotate -90 * x translate 29 * y }

#declare UnderTilesRoof = prism{ linear_sweep linear_spline -48, 0, 7, <-30,0>, <-68,16>,<-68,17>, <-30,1>,<4,17>,<4,16>, <-30, 0>
								rotate 90 * x translate < 0, 45, 4 > texture{ T_Wood1 } }

#declare ShelterPart1 =
union{ 
	prism{ linear_sweep linear_spline 0, 1, 9, <5,-0.5> <6,0> <5.5,0> <0,5.5> <0,5> <5,0> <0,0> <0,0.5> <5, -0.5> }
	box {<0,0,6> <-1,1,-3> }
}

#declare ShelterPart2 =
union{ 
	object{ShelterPart1 rotate 90*x translate -10*z texture{ T_Wood30 rotate 90 * x } }
	object{ShelterPart1 rotate 90*x texture { T_Wood30 rotate 90 * x } }
	//Roof the shelter:
	prism{ linear_sweep linear_spline 12, -2, 5, <6,0> <-1,-3> <-1,-3.5> <6,-0.5> < 6, 0> rotate 90*x translate -10*z 
		texture { T_Wood7}
		texture {SnowShelterTexture}
	}
}             

#declare DepthLattesGroup = 
union{
	#for( ItDepth, 0, 29 )
		object{ Latte1 translate ItDepth * y }
	#end
	texture{ T_Wood13 rotate 90 * x rotate -90 * z }
}

#declare WidthLattesGroup =
union{
	//lattes_en_largeur (Latte2,0)
	#for( ItWidth, 0, 29 )
		object{ Latte2 translate ItWidth * y }
	#end
	texture{ T_Wood13 }
}



#declare GarretLatteGroup =     //au grenier en haut
union{
	#for( ItGarret, 0, 59, 1 )
		object{ GarretLatte translate -ItGarret * x }
	#end
	texture{ T_Wood30 rotate 90 * x }
}


//Placement premire tuile      
#declare TileObj =
difference {  
	union{ 	cylinder { <0, 0, 0>, <0, 3, 0>, 0.75 }  
			cone { <0, 3, 0>, 0.75, <0, 4, 0>, 0.25 }
	}
	cylinder { <0 ,-1, 0>, <0, 5, 0>, 0.25}
	box {<-2,-2,0><2,5,-2>}
	translate -4 * y
}

#macro PlaceTiles( )
	#local XCoord = 0;
	#local YCoord = 0;
	#local RowNum = 0;
	#for( ItTile, 0, 279 , 0.75 )
		object{ TileObj rotate < 0, 90, 90 - 23.592 > translate < -30, 45, -43.5 >
			translate < XCoord, YCoord, RowNum >
		}
		#if( RowNum >= 46
		)
			#local XCoord = XCoord + 2.915475947;
			#local YCoord = YCoord - 1.35;
			#local RowNum = 0;
		#end
		#local RowNum = RowNum + 1.5;
	#end
#end

#declare HouseFront=
union{ 
	difference{
		union{
			intersection{ 
				object {IntersectionFrontPrism}
				union {
					object{ DepthLattesGroup}
					object{WidthLattesGroup}
					object{GarretLatteGroup}
				}
			}
			object{ UnderTilesRoof }
			object{ ShelterPart2 translate < 1, 10, -4 > }
		}
		box{ <-4,4,-32 > <4,14,-24>}//Left front window hole
		//left window holes
		box{<-6,8,-1> <-10,13,2>}
		box{<-16,8,-1> <-20,13,2>}
		box{<-40,8,-1> <-44,13,2>}
		box{<-50,8,-1> <-54,13,2>}                
		//Hole under shelter
		box {<2,0,-12><-2,12,-5>}
		//Hole of the upstair window
		box {<-2,20,-15> <2,20+8,-25>}      
		//Hole of the balcony door
		box {<-25,16,-2> <-35,28,2>}
		//Hole of the door below the balcony
		box {<-26.5,0,-2> <-33.5,12,2>} 
	}
	object {SmallWindowFrame translate <-5.5,8,0>}
	object {SmallWindowFrame translate <-15.5,8,0>}
	object {SmallWindowFrame translate <-39.5,8,0>}
	object {SmallWindowFrame translate <-49.5,8,0>}
	object {LeftDoorObj translate -10*z}
	object{ union{ PlaceTiles() texture {TilesTexture} } } 
}                

#declare CompleteHouse =
union{ 
	object{HouseFront}
	box{<0,0,-12><1,1,-5> texture {T_Stone8} }//Step of the left door
	object {CompleteBalcony translate <-50,16,0>}
	object {LeftWindow}
	object {CompleteShutter scale <1, 10 / 8, 1> translate <1,4,-36> }
	object {CompleteShutter scale <1, 10 / 8, 1> translate < 1,4,-24>}
	//Shutters of the balcony
	object {CompleteShutter scale <1, 12/8, 1> rotate -90*y translate <-35,16,1>} 
	object {CompleteShutter scale <1, 12/8, 1> rotate -90*y translate <-20,16,1>}
	
	difference {
		box {<-25,16,0> <-35,28,1>}
		box {<-25.5,16.5,-1> <-29.5,27.5,2>}
		box {<-30.5,16.5,-1> <-34.5,27.5,2>}
		texture {T_Wood11}
	}
	box {<-25,16,-2> <-35,28,0> texture{ GlassTexture } }
        
	//The door under the balcony
	difference {
		box{<-26.5,0,-1> <-33.5,12,1>} 
		box{<-27,0,0> <-33,11.5,2>}
		texture {T_Wood11}
	} 
	object{ UpstairWindow translate <1,20,-25> texture{ GlassTexture } }
}                                                 