
#macro DetermineYPosOfWell( HeightField, WellSize, WellPosition, Interval )
	#declare XDimension = int( WellSize.x / Interval );
	#declare ZDimension = int( WellSize.z / Interval );
	#debug concat( "XDim is: ", str( XDimension, 0, 1), " and ZDim is: ", str( ZDimension, 0, 1 ), " \n")
	
	#local MinimumYPos = 1000;
	#for( ItX, 0, XDimension - 1, 1 )
		#for( ItZ, 0, ZDimension - 1, 1 )
			#local Normal = < 0, 0, 0 >;
			#local StartPosition = < ( WellPosition.x - WellSize.x / 2 ) / Interval, 1000, ( WellPosition.z - WellSize.z / 2 ) / Interval >;
			#local Position = trace( HeightField, StartPosition, -y, Normal );
			#if( Normal.x != 0 | Normal.y != 0 | Normal.z != 0 )
				#if( Position.y < MinimumYPos )
					#local MinimumYPos = Position.y;
				#end
			#end
		#end
	#end
	MinimumYPos;
#end
